# 画面設計書 51-フォームレイアウト（Foundation 5）

## 概要

本ドキュメントは、Symfony 8.1のTwig Bridgeが提供するFoundation 5対応フォームレイアウトテーマ（`foundation_5_layout.html.twig`）の画面設計書である。このテンプレートは、ZURB Foundation 5 CSSフレームワークに準拠したフォーム要素のレンダリングルールを定義するTwigテーマファイルであり、Symfonyのフォームコンポーネントと連携してFoundation 5スタイルのフォームUIを生成する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーション開発において、Foundation 5 CSSフレームワークを採用しているプロジェクトでは、Symfonyフォームの出力HTMLがFoundation 5のグリッドシステムやコンポーネントクラスに準拠している必要がある。本テーマファイルは、Symfonyの標準フォームレンダリング機能にFoundation 5固有のCSSクラスやHTML構造を適用し、フレームワーク標準のデザインガイドラインに沿ったフォームUIを自動生成することを目的としている。これにより、開発者はフォームの見た目を手動で調整する手間を省き、一貫性のあるUIを効率的に構築できる。

**画面へのアクセス方法**：本テンプレートは直接URLでアクセスする画面ではなく、Symfonyの設定ファイル（`twig.yaml`や`config/packages/twig.yaml`）で`form_themes`として登録することで、フォームレンダリング時に自動的に適用される。設定例：`twig: form_themes: ['foundation_5_layout.html.twig']`

**主要な操作・処理内容**：
1. フォームウィジェットのレンダリング - テキスト入力、テキストエリア、セレクトボックス、チェックボックス、ラジオボタンなどの各フォーム要素にFoundation 5のCSSクラス（`error`、`button`、`row collapse`等）を付与してレンダリングする
2. 通貨・パーセント入力のグリッドレイアウト - Foundation 5の`row collapse`グリッドシステムを使用して、通貨記号やパーセント記号と入力フィールドを横並びにレイアウトする
3. 日時入力のグリッドレイアウト - 日付（年・月・日）や時刻（時・分・秒）の各フィールドをFoundation 5のグリッドカラムで配置する
4. エラー表示のFoundation対応 - バリデーションエラー時にFoundation 5の`small.error`要素やアラートボックス（`div.alert-box.alert`）でエラーメッセージを表示する
5. ラベル・行レイアウトのFoundation対応 - フォーム行を`row`クラス付きdivで囲み、`large-12 columns`クラスで全幅レイアウトを適用する

**画面遷移**：本テンプレートは画面遷移を持たない。フォームテーマとしてSymfonyフォームのレンダリング時に使用される共通テンプレートである。フォームの送信先はフォームを使用する個別画面のコントローラーによって決定される。

**権限による表示制御**：本テーマファイル自体には権限制御はない。権限による表示制御はフォームを使用する個別画面のロジックで行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Foundation 5対応のフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるFoundation 5用ブロック定義 |

## 画面種別

テンプレートテーマ（フォームレンダリング用共通テーマファイル）

## URL/ルーティング

本テンプレートは直接URLでアクセスされるものではない。`twig.yaml`の`form_themes`設定により、フォームレンダリング時に自動的に適用される。

## 入出力項目

本テーマはTwigブロックのオーバーライドにより各フォームタイプのレンダリングをカスタマイズする。以下はオーバーライドされるブロックと対応するフォームタイプの一覧である。

| ブロック名 | 対応フォームタイプ | 入力変数 | 出力HTML |
|-----------|-------------------|---------|---------|
| form_widget_simple | TextType等 | `errors`, `attr` | エラー時に`error`クラスを付与した`<input>` |
| textarea_widget | TextareaType | `errors`, `attr` | エラー時に`error`クラスを付与した`<textarea>` |
| button_widget | ButtonType | `attr` | `button`クラスを付与した`<button>` |
| money_widget | MoneyType | `money_pattern` | `row collapse`グリッドによる通貨入力 |
| percent_widget | PercentType | `symbol` | `row collapse`グリッドによるパーセント入力 |
| datetime_widget | DateTimeType | `widget`, `form.date`, `form.time` | グリッドレイアウトの日時入力 |
| date_widget | DateType | `widget`, `date_pattern` | グリッドカラムによる日付入力 |
| time_widget | TimeType | `widget`, `with_seconds` | グリッドカラムによる時刻入力 |
| choice_widget_collapsed | ChoiceType(collapsed) | `errors`, `multiple`, `required`, `placeholder` | エラー対応セレクトボックス |
| choice_widget_expanded | ChoiceType(expanded) | `label_attr` | インライン/通常リスト表示 |
| checkbox_widget | CheckboxType | `errors`, `parent_label_class` | エラー対応チェックボックス |
| radio_widget | RadioType | `errors`, `parent_label_class` | エラー対応ラジオボタン |
| form_label | 全フォームタイプ | `errors`, `label_attr` | エラー時に`error`クラスを付与したラベル |
| form_row_render | 全フォームタイプ | `row_attr`, `compound`, `valid` | `row`/`large-12 columns`でラップしたフォーム行 |
| form_errors | 全フォームタイプ | `errors`, `form` | `small.error`またはアラートボックスによるエラー表示 |

## 表示項目

フォームテーマとして、以下のFoundation 5固有のUI要素を出力する。

| 表示要素 | CSSクラス | 説明 |
|---------|----------|------|
| フォーム行 | `row`, `large-12 columns` | 各フォーム行を全幅グリッドで表示 |
| 通貨プレフィックス/ポストフィックス | `small-3 large-2 columns`, `prefix`/`postfix` | 通貨記号の表示位置 |
| パーセントポストフィックス | `small-3 large-2 columns`, `postfix` | パーセント記号の表示 |
| エラー表示（子要素） | `small.error` | 個別フィールドのエラーメッセージ |
| エラー表示（ルート） | `div.alert-box.alert` | ルートフォームのエラーメッセージ |
| ボタン | `button` | Foundation 5標準ボタンスタイル |
| インラインリスト | `inline-list` | インライン表示の選択肢リスト |
| チェックボックス/ラジオ行 | `checkbox`/`radio` | Foundation 5の標準入力スタイル |

## イベント仕様

### 1-フォームレンダリング

Twigの`form_widget()`、`form_row()`、`form_label()`、`form_errors()`関数が呼び出されると、本テーマで定義されたブロックが実行される。

### 2-エラー状態の動的クラス付与

バリデーションエラーが存在する場合（`errors|length > 0`）、対象のフォーム要素（input、textarea、select、label）に`error`クラスが動的に追加される。

### 3-選択肢展開のインライン/通常切替

`label_attr.class`に`-inline`が含まれる場合、選択肢を`ul.inline-list`で表示する。含まれない場合は通常のdivラップで表示する。

## データベース更新仕様

### 操作別データベース影響一覧

本テーマファイルはフォームのHTML表示のみを担当し、データベース操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | 表示条件 | 表示形式 | 内容 |
|---------------|---------|---------|------|
| バリデーションエラー（子フォーム） | `errors|length > 0` かつ `form is not rootform` | `<small class="error">` | バリデーションエラーメッセージ（カンマ区切り） |
| バリデーションエラー（ルートフォーム） | `errors|length > 0` かつ `form is rootform` | `<div data-alert class="alert-box alert">` | バリデーションエラーメッセージ（カンマ区切り） |

## 例外処理

本テーマファイルはレンダリングのみを行うため、例外処理は含まない。テーマの読み込みに失敗した場合は、Twigのテンプレートローダーが例外をスローする。

## 備考

- 本テーマは`form_div_layout.html.twig`を継承（`{% extends 'form_div_layout.html.twig' %}`）しており、オーバーライドしないブロックは親テーマの定義がそのまま使用される
- Foundation 5は現在レガシーフレームワークとなっており、Foundation 6以降への移行が推奨される
- `data-customforms="disabled"`属性がmultipleセレクトに付与され、Foundation 5のカスタムフォーム機能を無効化する
- `choice_widget_collapsed`ブロックでは`separator_html`変数による区切り線のHTML/テキスト切替をサポートする

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Symfonyフォームのレンダリングにおけるテーマの仕組みとTwigブロックの継承関係を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 親テーマ。全フォームブロックのデフォルト実装を定義。Foundation 5テーマがオーバーライドする元のブロックを理解する |

**読解のコツ**: Twigのブロック継承では`{% extends %}`で親テーマを指定し、`{% block ブロック名 %}`で個別ブロックをオーバーライドする。`{{ parent() }}`は親ブロックの出力をそのまま含める記法である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | foundation_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_5_layout.html.twig` | 本テーマファイルのエントリーポイント。行1で`form_div_layout.html.twig`を継承している |

**主要処理フロー**:
1. **行1**: `{% extends 'form_div_layout.html.twig' %}` - 親テーマの継承宣言
2. **行6-11**: `form_widget_simple` - エラー時に`error`クラスを付与して親ブロックを呼び出し
3. **行20-23**: `button_widget` - `button`クラスを付与して親ブロックを呼び出し
4. **行25-42**: `money_widget` - `row collapse`グリッドで通貨入力フィールドをレイアウト
5. **行44-59**: `percent_widget` - `row collapse`グリッドでパーセント入力フィールドをレイアウト
6. **行61-75**: `datetime_widget` - 日付と時刻をグリッドカラムで配置
7. **行145-177**: `choice_widget_collapsed` - エラークラスとmultiple属性対応のセレクトボックス
8. **行229-234**: `form_label` - エラー時にラベルに`error`クラスを付与
9. **行284-293**: `form_row_render` - `row`/`large-12 columns`グリッドでフォーム行をラップ
10. **行337-345**: `form_errors` - Foundation 5の`small.error`またはアラートボックスでエラー表示

#### Step 3: Twig Bridgeのフォームレンダリング機構を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | Twigのフォームレンダリング関数（`form_widget`、`form_row`等）を登録するTwig拡張クラス |

### プログラム呼び出し階層図

```
Twigテンプレート（form_widget(form) 呼び出し）
    |
    +-- FormExtension（Twig関数の解決）
    |       |
    |       +-- TwigRendererEngine（テーマブロックの解決）
    |               |
    |               +-- foundation_5_layout.html.twig（本テーマ）
    |                       |
    |                       +-- form_div_layout.html.twig（親テーマ / parent()呼び出し）
    |
    +-- FormRenderer（レンダリング実行）
```

### データフロー図

```
[入力]                        [処理]                              [出力]

FormView                      foundation_5_layout.html.twig       Foundation 5
(フォームデータ、            ├── form_widget_simple             CSSクラス付き
 バリデーション結果、         ├── money_widget                   HTML要素
 フォーム設定)               ├── percent_widget                  ├── <input class="error">
        |                     ├── datetime_widget                 ├── <div class="row collapse">
        +---> Twig Engine --> ├── date_widget                     ├── <small class="error">
                              ├── choice_widget_collapsed         └── <div class="row">
                              ├── form_label                          <div class="large-12 columns">
                              ├── form_row_render
                              └── form_errors
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| foundation_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_5_layout.html.twig` | テンプレート | Foundation 5フォームテーマ本体（346行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 親テーマ。div要素ベースの標準フォームレイアウト（482行） |
| FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | ソース | Twigフォームレンダリング関数の登録 |
